#include <EEPROM.h>
#include "config.h"
#include "GyverButton.h"
#include "SerialCommand.h"
SerialCommand sCmd;
GButton butt1(In1, HIGH_PULL, NORM_OPEN);
GButton butt2(In2, HIGH_PULL, NORM_OPEN);
GButton butt3(In3, HIGH_PULL, NORM_OPEN);
GButton butt4(In4, HIGH_PULL, NORM_OPEN);
GButton butt5(In5, HIGH_PULL, NORM_OPEN);
GButton butt6(In6, HIGH_PULL, NORM_OPEN);
//------------------------------------------------------
void(* resetFunc) (void) = 0;                       //Reset function
//-------------------------------------------------------
void setup() {
  pinMode(Out1, OUTPUT);
  digitalWrite(Out1, HIGH);
  pinMode(Out2, OUTPUT);
  digitalWrite(Out2, HIGH);
  pinMode(Out3, OUTPUT);
  digitalWrite(Out3, HIGH);
  pinMode(Out4, OUTPUT);
  digitalWrite(Out4, HIGH);
  pinMode(Out5, OUTPUT);
  digitalWrite(Out5, HIGH);
  pinMode(Out6, OUTPUT);
  digitalWrite(Out6, HIGH);
  pinMode(Out7, OUTPUT);
  digitalWrite(Out7, HIGH);
  pinMode(Out8, OUTPUT);
  digitalWrite(Out8, HIGH);
  input_configs();                  //debounce, click timeout
  Serial.begin(115200);
  defaultEEPROM();                  //Check For Default config
  scmd_AddCommand();   // adding commands to cmd handle

  eI1S1 = read_string(8, 1);
  eI1S2 = read_string(8, 9);
  eI1S3 = read_string(8, 17);
  eI2S1 = read_string(8, 25);
  eI2S2 = read_string(8, 33);
  eI2S3 = read_string(8, 41);
  eI3S1 = read_string(8, 49);
  eI3S2 = read_string(8, 57);
  eI3S3 = read_string(8, 65);
  eI4S1 = read_string(8, 73);
  eI4S2 = read_string(8, 81);
  eI4S3 = read_string(8, 89);
  eI5S1 = read_string(8, 97);
  eI5S2 = read_string(8, 105);
  eI5S3 = read_string(8, 113);
  eI6S1 = read_string(8, 121);
  eI6S2 = read_string(8, 129);
  eI6S3 = read_string(8, 137);
//  Serial.println(F("Started"));
}

void loop() {
  sCmd.readSerial();
   inputStatusReply();
  butt1.tick();
  butt2.tick();
  butt3.tick();
  butt4.tick();
  butt5.tick();
  butt6.tick();
  process_in1();
  process_in2();
  process_in3();
  process_in4();
  process_in5();
  process_in6();
}
