//////////////////////////Read String EEPROM//////////////////////////
String read_string(int l, int p) {
  String temp;
  for (int n = p; n < l + p; ++n)
  {
    if (char(EEPROM.read(n)) != ';') {
      if (isWhitespace(char(EEPROM.read(n)))) {
        //do nothing
      } else temp += String(char(EEPROM.read(n)));

    } else n = l + p;

  }
  return temp;
}

void write_EEPROM(String x, int pos) {
  for (int n = pos; n < x.length() + pos; n++) {
    EEPROM.write(n, x[n - pos]);
  }
}


void defaultEEPROM() {       // Check for default donfig
  if (!digitalRead(In1) && !digitalRead(In3)) {                  //Reset controller on startup short 1 & 3 input to the ground
    delay(10000);                                                   // release in 10 sec
    if (digitalRead(In1) && digitalRead(In3) && !digitalRead(In2)) {  // short 2 input to ground and wait 10 sec, after reset controller reboots
      write_EEPROM("1", 0);

    }
  }
  //Serial.println(read_string(1024, 0));

  if (read_string(1, 0) != "0") {
    Serial.println(F("Default configuration loaded"));
    write_EEPROM("0", 0); //D0S1
    //--------------------------Input 1 Config
    write_EEPROM("00000000", 1); //I1S1 Single
    write_EEPROM("00000000", 9);  //I1S2 Double
    write_EEPROM("10000000", 17);  //I1S3 Pressed
    //-------------------------Input 2 config
    write_EEPROM("00000000", 25); //I2S1 Single
    write_EEPROM("00000000", 33);  //I2S2 Double
    write_EEPROM("02000000", 41);  //I2S3 Pressed
    //--------------------------Input 3 config
    write_EEPROM("00000000", 49); //I3S1 Single
    write_EEPROM("00000000", 57);  //I3S2 Double
    write_EEPROM("00300000", 65);  //I3S3 Pressed
    //---------------------------Input 4 config
    write_EEPROM("00000000", 73); //I4S1 Single
    write_EEPROM("00000000", 81);  //I4S2 Double
    write_EEPROM("00040000", 89);  //I4S3 Pressed
    //---------------------------Input 5 config
    write_EEPROM("00000000", 97); //I5S1 Single
    write_EEPROM("00000000", 105); //I5S2 Double
    write_EEPROM("00005000", 113);  //I5S3 Pressed
    //---------------------------Input 6 config
    write_EEPROM("00000070", 121); //I6S1 Single
    write_EEPROM("00000008", 129);  //I6S2 Double
    write_EEPROM("00000600", 137);  //I6S3 Pressed
    delay(1000);
    resetFunc();
  }
}
