import sqlite3
import db_f
from datetime import date
from prettytable import PrettyTable




# Help function in command line
def help_f():
    print('''Commands:
    SZ_BabySWTime_console_1.01

    help - open list with commands
    adds - saves time when baby go to sleep "time format is XX:XX" (enter "back" to exit from adds menu)
    addw - saves time when baby waked up "time format is XX:XX" (enter "back" to exit from addw menu)
    shows - show table with calculated sleep time
    showa - show table with calculated awake time
    delall - full erase of database
    dels - delete last sleep record
    dela - delete last wake up record
    exit - exit from program''')


# Function to get/check sleep time from command line input 
def add_sleep_time_f(user_input):
    if len(user_input) == 5:
        if user_input[0:2].isnumeric() and user_input[2] == ":" and user_input[3:5].isnumeric():
           if (int(user_input[0:2]) >=0 and int(user_input[0:2]) <=24) and (int(user_input[3:5]) >=0 and int(user_input[3:5]) <=59):
               sleep_hour = user_input[0:2]
               sleep_minute = user_input[3:5]
               #Write time to add_sleep table
               db_f.save_to_add_sleep_db(date.today(), sleep_hour, sleep_minute)
               return(False)
           else:
               print("Value not correct")
               return(True)
        else:
            print("Value not correct")
            return(True)
    elif user_input == "back":
        return(False) 
    else:
        print("Value not correct")
        return(True)


# Command line function
def command_line_f(command_line):
    if command_line == "help":
        help_f()
        return(True)
    elif command_line == "exit":
        return(False) 
    elif command_line == "adds":
        i = True
        while i:
            user_input = input("Enter time when go to sleep (time format XX:XX): ")
            i = add_sleep_time_f(user_input)
        return(True)
    elif command_line == "addw":
        i = True
        while i:
            user_input = input("Enter time when waked up (time format XX:XX): ")
            i = add_wakeup_time_f(user_input)
        return(True)
    elif command_line == "shows":
        shows_f()
        return(True)
    elif command_line == "showa":
        showa_f()
        return(True)
    elif command_line == "delall":
        delall_f()
        return(True)
    elif command_line == "dels":
        dels_f()
        return(True)       
    elif command_line == "dela":
        dela_f()
        return(True)
    else:
        print("Command not recognised ")
        return(True)


# Function to get/check time from command line input 
def add_wakeup_time_f(user_input):
    if len(user_input) == 5:
        if user_input[0:2].isnumeric() and user_input[2] == ":" and user_input[3:5].isnumeric():
           if (int(user_input[0:2]) >=0 and int(user_input[0:2]) <=24) and (int(user_input[3:5]) >=0 and int(user_input[3:5]) <=59):
               wake_hour = user_input[0:2]
               wake_minute = user_input[3:5]
                #Write time to add_sleep table
               db_f.save_to_add_wakeup_db(date.today(), wake_hour, wake_minute)
               return(False)
           else:
               print("Value not correct")
               return(True)
        else:
            print("Value not correct")
            return(True)
    elif user_input == "back":
        return(False)
    else:
        print("Value not correct")
        return(True)


# Function shows sleep time table
def shows_f():
    con = sqlite3.connect('Database.db')
    cur = con.cursor()
    cur.execute("SELECT * FROM sleep_time")
    rows = cur.fetchall()
    my_table = PrettyTable()
    for row in rows:
        my_table.add_row(row)
    my_table.field_names = ["No.", "Date", "Sleeping time"]
    print(my_table)

# Function shows awake time table
def showa_f():
    con = sqlite3.connect('Database.db')
    cur = con.cursor()
    cur.execute("SELECT * FROM wakeup_time")
    rows = cur.fetchall()
    my_table = PrettyTable()
    for row in rows:
        my_table.add_row(row)
    my_table.field_names = ["No.", "Date", "Awake time"]
    print(my_table)

# Function drops DB
def delall_f():
    con = sqlite3.connect('Database.db')
    cur = con.cursor()
    cur.execute("DELETE FROM sleep_time;",)
    cur.execute("DELETE FROM wakeup_time;",)
    cur.execute("DELETE FROM add_sleep;",)
    cur.execute("DELETE FROM add_wakeup;",)
    con.commit()
    con.close()
    print("Database erased")


# Function delete last record from add_sleep, wakeup_time table 
def dels_f():
    con = sqlite3.connect('Database.db')
    cur = con.cursor()
    cur.execute("DELETE FROM add_sleep WHERE id = (SELECT MAX(id) FROM add_sleep)")
    cur.execute("DELETE FROM wakeup_time WHERE id = (SELECT MAX(id) FROM wakeup_time)")
    con.commit()
    con.close()
    print("Last sleep record deleted")


# Function delete last record from add_wakeup, sleep_time table 
def dela_f():
    con = sqlite3.connect('Database.db')
    cur = con.cursor()
    cur.execute("DELETE FROM add_wakeup WHERE id = (SELECT MAX(id) FROM add_wakeup)")
    cur.execute("DELETE FROM sleep_time WHERE id = (SELECT MAX(id) FROM sleep_time)")
    con.commit()
    con.close()
    print("Last wake up record deleted")