import sqlite3
import time_calc_f

# Function to write calculated time to sleep
def write_data_to_sleep(sleep_time):
    con = sqlite3.connect('Database.db')
    cur = con.cursor()
    cur.execute("""SELECT date FROM add_sleep ORDER BY id DESC LIMIT 1""")
    date_created =  cur.fetchone()[0]
    cur.execute("""INSERT INTO sleep_time (date, time) 
        VALUES (?, ?)""", (date_created, sleep_time))
    con.commit()
    con.close()


# Function to write calculated time to wakeup
def write_data_to_wakeup(wakeup_time):
    con = sqlite3.connect('Database.db')
    cur = con.cursor()
    cur.execute("""SELECT date FROM add_wakeup ORDER BY id DESC LIMIT 1""")
    date_created =  cur.fetchone()[0]
    cur.execute("""INSERT INTO wakeup_time (date, time) 
        VALUES (?, ?)""", (date_created, wakeup_time))
    con.commit()
    con.close()

 
# Function to operate with times in add tables
def get_data_from_add_sleep():
    con = sqlite3.connect('Database.db')
    cur = con.cursor()
    cur.execute("""SELECT hour FROM add_sleep ORDER BY id DESC LIMIT 1""")
    sleep_last_h = int(cur.fetchone()[0])
    cur.execute("""SELECT minute FROM add_sleep ORDER BY id DESC LIMIT 1""")
    sleep_last_m = int(cur.fetchone()[0])
    cur.execute("""SELECT hour FROM add_wakeup ORDER BY id DESC LIMIT 1""")
    wakeup_last_h = int(cur.fetchone()[0])
    cur.execute("""SELECT minute FROM add_wakeup ORDER BY id DESC LIMIT 1""")
    wakeup_last_m = int(cur.fetchone()[0])
    sleep_time = time_calc_f.sleep_f(wakeup_last_h, wakeup_last_m, sleep_last_h, sleep_last_m)
    write_data_to_sleep(sleep_time)

# Function to operate with times in add tables
def get_data_from_add_wakeup():
    con = sqlite3.connect('Database.db')
    cur = con.cursor()
    cur.execute("""SELECT hour FROM add_sleep ORDER BY id DESC LIMIT 1""")
    sleep_last_h = int(cur.fetchone()[0])
    cur.execute("""SELECT minute FROM add_sleep ORDER BY id DESC LIMIT 1""")
    sleep_last_m = int(cur.fetchone()[0])
    cur.execute("""SELECT hour FROM add_wakeup ORDER BY id DESC LIMIT 1""")
    wakeup_last_h = int(cur.fetchone()[0])
    cur.execute("""SELECT minute FROM add_wakeup ORDER BY id DESC LIMIT 1""")
    wakeup_last_m = int(cur.fetchone()[0])
    awake_time = time_calc_f.wakeup_f(wakeup_last_h, wakeup_last_m, sleep_last_h, sleep_last_m)
    write_data_to_wakeup(awake_time)
        

# Function thas saves time to add_sleep table
def save_to_add_sleep_db(date_created, sleep_hour, sleep_minute):
    con = sqlite3.connect('Database.db')
    cur = con.cursor()
    sleep_exist = cur.execute("SELECT id FROM add_sleep ORDER BY id DESC LIMIT 1")
    #Check if table add_sleep is clean  
    if cur.fetchone() is None:
        cur.execute("""INSERT INTO add_sleep (date, hour, minute ) 
        VALUES (?, ?, ?)""", (date_created, sleep_hour, sleep_minute))
        con.commit()
        con.close()
        print("Sleep time saved")
    #Check if table add_wakeup has record
    else:
        sleep_exist = cur.execute("SELECT id FROM add_sleep ORDER BY id DESC LIMIT 1")
        sleep_exist_id = int(cur.fetchone()[0])
        wakeup_exist = cur.execute("""SELECT id FROM add_wakeup ORDER BY id DESC LIMIT 1""")
        wakeup_exist_id = int(cur.fetchone()[0])
        if sleep_exist_id == wakeup_exist_id:
            cur.execute("""INSERT INTO add_sleep (date, hour, minute ) 
        VALUES (?, ?, ?)""", (date_created, sleep_hour, sleep_minute))
            con.commit()
            con.close()
            print("Sleep time saved") 
            get_data_from_add_wakeup()  
        else:
            print("Please enter wake up time")


# Function thas saves time to add_wakeup table
def save_to_add_wakeup_db(date_created, wakeup_hour, wakeup_minute):
    con = sqlite3.connect('Database.db')
    cur = con.cursor()
    cur.execute("SELECT id FROM add_sleep ORDER BY id DESC LIMIT 1")
    #Check if table add_sleep is clean
    if cur.fetchone() is None:
        print("Please enter sleep time")
    #Check if table add_wakeup has record
    else:
        sleep_exist = cur.execute("SELECT id FROM add_sleep ORDER BY id DESC LIMIT 1")
        sleep_exist_id = cur.fetchone()
        if sleep_exist_id is not None:
            sleep_exist_id = (int(sleep_exist_id[0]))
        wakeup_exist = cur.execute("""SELECT id FROM add_wakeup ORDER BY id DESC LIMIT 1""")
        wakeup_exist_id = cur.fetchone()
        if wakeup_exist_id is not None:
            wakeup_exist_id = (int(wakeup_exist_id[0]))
        else:
            wakeup_exist_id = 0
        if sleep_exist_id > wakeup_exist_id:
            cur.execute("""INSERT INTO add_wakeup (date, hour, minute ) 
        VALUES (?, ?, ?)""", (date_created, wakeup_hour, wakeup_minute))
            con.commit()
            con.close()
            print("Wake up time saved")   
            get_data_from_add_sleep()
        else:
            print("No sleep record found")