//////////////////////////Read String EEPROM//////////////////////////
String read_string(int l, int p) {
  String temp;
  for (int n = p; n < l + p; ++n)
  {
    if (char(EEPROM.read(n)) != ';') {
      if (isWhitespace(char(EEPROM.read(n)))) {
        //do nothing
      } else temp += String(char(EEPROM.read(n)));

    } else n = l + p;

  }
  return temp;
}

void write_EEPROM(String x, int pos) {
  for (int n = pos; n < x.length() + pos; n++) {
    EEPROM.write(n, x[n - pos]);
  }
}

void defaultEEPROM() {       // Check for default donfig
  if (read_string(1, 0) != "0") {
    Serial.println(F("Default configuration loaded"));
    write_EEPROM("0", 0); //D0S1
    //--------------------------Input 1 Config
    write_EEPROM("10000000", 1); //I1S1 Single
    write_EEPROM("10000000", 9);  //I1S2 Double
    //-------------------------Input 2 config
    write_EEPROM("02000000", 17);  //I1S3 Pressed
    write_EEPROM("02000000", 25); //I2S1 Single
    //--------------------------Input 3 config
    write_EEPROM("00300000", 33);  //I2S2 Double
    write_EEPROM("00300000", 41);  //I2S3 Pressed
    //---------------------------Input 4 config
    write_EEPROM("00040000", 49); //I3S1 Single
    write_EEPROM("00040000", 57);  //I3S2 Double
    //---------------------------Input 5 config
    write_EEPROM("00005000", 65);  //I3S3 Pressed
    write_EEPROM("00005000", 73); //I4S1 Single
    //---------------------------Input 6 config
    write_EEPROM("00000600", 81);  //I4S2 Double
    write_EEPROM("00000600", 89);  //I4S3 Pressed
    //---------------------------Input 7 config
    write_EEPROM("00000070", 97); //I5S1 Single
    //---------------------------Input 8 config
    write_EEPROM("00000008", 105); //I5S2 Double
    delay(1000);
    resetFunc();
  }
}

void ShowConf() {
  Serial.println( read_string(1, 0));
  Serial.println( read_string(8, 1));
  Serial.println( read_string(8, 9));
  Serial.println( read_string(8, 17));
  Serial.println( read_string(8, 25));
  Serial.println( read_string(8, 33));
  Serial.println( read_string(8, 41));
  Serial.println( read_string(8, 49));
  Serial.println( read_string(8, 57));
  Serial.println( read_string(8, 65));
  Serial.println( read_string(8, 73));
  Serial.println( read_string(8, 81));
  Serial.println( read_string(8, 89));
  Serial.println( read_string(8, 97));
  Serial.println( read_string(8, 105));

}
