import serial
import time
import os


# COM port config from config.txt
with open('config.txt') as f:
   lines = f.readlines()


for line in lines:
   if "PORT" in line:
       port_com = line.split(" = ")[1]
       rep=["\n"]
       for r in rep:
          port_com=port_com.replace(r,"")


# COM port starting
ser = serial.Serial(port=port_com, baudrate=9600, timeout=.1)

# Wait while controller boot after serial connected
time.sleep(2)

# Read boot stuff information
while ser.readline():
    unused_data = ser.readline()

# Bridge function
while True:

    time.sleep(0.1)
    if os.path.isfile('commands'):
        with open('commands', 'r') as f:
                cmd = f.read()+ '\r\n'
                ser.write(cmd.encode())
                f.close()
        os.remove('commands')